"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict = (
    TypeAliasType(
        "UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict",
        Union[float, str],
    )
)
r"""How much liquidity to take out in percentage."""


UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawal = TypeAliasType(
    "UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawal", Union[float, str]
)
r"""How much liquidity to take out in percentage."""


class UniswapWithdrawLiquidityProvisionRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class UniswapWithdrawLiquidityProvisionRequestTypedDict(TypedDict):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    percentage_for_withdrawal: (
        UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict
    )
    r"""How much liquidity to take out in percentage."""
    chain: UniswapWithdrawLiquidityProvisionRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class UniswapWithdrawLiquidityProvisionRequest(BaseModel):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    percentage_for_withdrawal: (
        UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawal
    )
    r"""How much liquidity to take out in percentage."""

    chain: UniswapWithdrawLiquidityProvisionRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"]],
            AfterValidator(validate_const("UNISWAP_WITHDRAW_LIQUIDITY_PROVISION")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
