"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawalTypedDict = TypeAliasType(
    "UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawalTypedDict",
    Union[float, str],
)
r"""How much liquidity to take out in percentage."""


UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawal = TypeAliasType(
    "UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawal", Union[float, str]
)
r"""How much liquidity to take out in percentage."""


class UniswapWithdrawLiquidityProvisionParamsTypedDict(TypedDict):
    r"""Endpoint parameters for liquidity provision withdrawal on uniswap v3.

    This action is performed in a multicall on the NonfungiblePosition Manager: https://github.com/Uniswap/v3-periphery/blob/0682387198a24c7cd63566a2c58398533860a5d1/contracts/base/Multicall.sol#L11-L27
    First, we call decrease liquidity then collect the tokens owed to the user.
    """

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    percentage_for_withdrawal: (
        UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawalTypedDict
    )
    r"""How much liquidity to take out in percentage."""
    action_type: Literal["UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"]


class UniswapWithdrawLiquidityProvisionParams(BaseModel):
    r"""Endpoint parameters for liquidity provision withdrawal on uniswap v3.

    This action is performed in a multicall on the NonfungiblePosition Manager: https://github.com/Uniswap/v3-periphery/blob/0682387198a24c7cd63566a2c58398533860a5d1/contracts/base/Multicall.sol#L11-L27
    First, we call decrease liquidity then collect the tokens owed to the user.
    """

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    percentage_for_withdrawal: (
        UniswapWithdrawLiquidityProvisionParamsPercentageForWithdrawal
    )
    r"""How much liquidity to take out in percentage."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"]],
            AfterValidator(validate_const("UNISWAP_WITHDRAW_LIQUIDITY_PROVISION")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_WITHDRAW_LIQUIDITY_PROVISION"
