"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .feeenum import FeeEnum
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UniswapSellExactlyRequestAmountInTypedDict = TypeAliasType(
    "UniswapSellExactlyRequestAmountInTypedDict", Union[float, str]
)
r"""The amount of the `token_in` to sell"""


UniswapSellExactlyRequestAmountIn = TypeAliasType(
    "UniswapSellExactlyRequestAmountIn", Union[float, str]
)
r"""The amount of the `token_in` to sell"""


class UniswapSellExactlyRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class UniswapSellExactlyRequestTypedDict(TypedDict):
    r"""Request model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to sell.."""
    token_out: str
    r"""The symbol or address of the token to buy.."""
    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """
    amount_in: UniswapSellExactlyRequestAmountInTypedDict
    r"""The amount of the `token_in` to sell"""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""
    chain: UniswapSellExactlyRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["UNISWAP_SELL_EXACTLY"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class UniswapSellExactlyRequest(BaseModel):
    r"""Request model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to sell.."""

    token_out: str
    r"""The symbol or address of the token to buy.."""

    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    amount_in: UniswapSellExactlyRequestAmountIn
    r"""The amount of the `token_in` to sell"""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""

    chain: UniswapSellExactlyRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_SELL_EXACTLY"]],
            AfterValidator(validate_const("UNISWAP_SELL_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_SELL_EXACTLY"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
