"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .feeenum import FeeEnum
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


UniswapSellExactlyParamsAmountInTypedDict = TypeAliasType(
    "UniswapSellExactlyParamsAmountInTypedDict", Union[float, str]
)
r"""The amount of the `token_in` to sell"""


UniswapSellExactlyParamsAmountIn = TypeAliasType(
    "UniswapSellExactlyParamsAmountIn", Union[float, str]
)
r"""The amount of the `token_in` to sell"""


class UniswapSellExactlyParamsTypedDict(TypedDict):
    r"""Parameters model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to sell.."""
    token_out: str
    r"""The symbol or address of the token to buy.."""
    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """
    amount_in: UniswapSellExactlyParamsAmountInTypedDict
    r"""The amount of the `token_in` to sell"""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""
    action_type: Literal["UNISWAP_SELL_EXACTLY"]


class UniswapSellExactlyParams(BaseModel):
    r"""Parameters model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to sell.."""

    token_out: str
    r"""The symbol or address of the token to buy.."""

    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    amount_in: UniswapSellExactlyParamsAmountIn
    r"""The amount of the `token_in` to sell"""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_SELL_EXACTLY"]],
            AfterValidator(validate_const("UNISWAP_SELL_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_SELL_EXACTLY"
