"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .feeenum import FeeEnum
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UniswapMintLiquidityProvisionParamsAmount0DesiredTypedDict = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount0DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapMintLiquidityProvisionParamsAmount0Desired = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount0Desired", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapMintLiquidityProvisionParamsAmount1DesiredTypedDict = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount1DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapMintLiquidityProvisionParamsAmount1Desired = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount1Desired", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapMintLiquidityProvisionParamsAmount0MinTypedDict = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount0MinTypedDict", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapMintLiquidityProvisionParamsAmount0Min = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapMintLiquidityProvisionParamsAmount1MinTypedDict = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount1MinTypedDict", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


UniswapMintLiquidityProvisionParamsAmount1Min = TypeAliasType(
    "UniswapMintLiquidityProvisionParamsAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class UniswapMintLiquidityProvisionParamsTypedDict(TypedDict):
    token0: str
    r"""The symbol or address of the first token in the pair."""
    token1: str
    r"""The symbol or address of the second token in the pair."""
    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """
    tick_lower: int
    r"""The lower tick of the range to mint the position in"""
    tick_upper: int
    r"""The upper tick of the range to mint the position in"""
    amount0_desired: UniswapMintLiquidityProvisionParamsAmount0DesiredTypedDict
    r"""The desired amount of the first token to deposit"""
    amount1_desired: UniswapMintLiquidityProvisionParamsAmount1DesiredTypedDict
    r"""The desired amount of the second token to deposit"""
    amount0_min: UniswapMintLiquidityProvisionParamsAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: UniswapMintLiquidityProvisionParamsAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    action_type: Literal["UNISWAP_MINT_LIQUIDITY_PROVISION"]
    recipient: NotRequired[Nullable[str]]
    r"""The address that will receive the LP tokens"""


class UniswapMintLiquidityProvisionParams(BaseModel):
    token0: str
    r"""The symbol or address of the first token in the pair."""

    token1: str
    r"""The symbol or address of the second token in the pair."""

    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    tick_lower: int
    r"""The lower tick of the range to mint the position in"""

    tick_upper: int
    r"""The upper tick of the range to mint the position in"""

    amount0_desired: UniswapMintLiquidityProvisionParamsAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: UniswapMintLiquidityProvisionParamsAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: UniswapMintLiquidityProvisionParamsAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: UniswapMintLiquidityProvisionParamsAmount1Min
    r"""The minimum amount of the second token to deposit"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_MINT_LIQUIDITY_PROVISION"]],
            AfterValidator(validate_const("UNISWAP_MINT_LIQUIDITY_PROVISION")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_MINT_LIQUIDITY_PROVISION"

    recipient: OptionalNullable[str] = UNSET
    r"""The address that will receive the LP tokens"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "recipient"]
        nullable_fields = ["recipient"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
