"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UniswapIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount0Desired = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount0Desired", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount1Desired = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount1Desired", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount0MinTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount0MinTypedDict", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount0Min = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount1MinTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount1MinTypedDict", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionRequestAmount1Min = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionRequestAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class UniswapIncreaseLiquidityProvisionRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class UniswapIncreaseLiquidityProvisionRequestTypedDict(TypedDict):
    r"""Request model for increasing liquidity provision in Uniswap V3."""

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    amount0_desired: UniswapIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict
    r"""The desired amount of the first token to deposit"""
    amount1_desired: UniswapIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict
    r"""The desired amount of the second token to deposit"""
    amount0_min: UniswapIncreaseLiquidityProvisionRequestAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: UniswapIncreaseLiquidityProvisionRequestAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    chain: UniswapIncreaseLiquidityProvisionRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["UNISWAP_ADD_LIQUIDITY"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class UniswapIncreaseLiquidityProvisionRequest(BaseModel):
    r"""Request model for increasing liquidity provision in Uniswap V3."""

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    amount0_desired: UniswapIncreaseLiquidityProvisionRequestAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: UniswapIncreaseLiquidityProvisionRequestAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: UniswapIncreaseLiquidityProvisionRequestAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: UniswapIncreaseLiquidityProvisionRequestAmount1Min
    r"""The minimum amount of the second token to deposit"""

    chain: UniswapIncreaseLiquidityProvisionRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_ADD_LIQUIDITY"]],
            AfterValidator(validate_const("UNISWAP_ADD_LIQUIDITY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_ADD_LIQUIDITY"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
