"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


UniswapIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount0Desired = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount0Desired", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount1Desired = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount1Desired", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount0MinTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount0MinTypedDict", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount0Min = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount1MinTypedDict = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount1MinTypedDict", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


UniswapIncreaseLiquidityProvisionParamsAmount1Min = TypeAliasType(
    "UniswapIncreaseLiquidityProvisionParamsAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class UniswapIncreaseLiquidityProvisionParamsTypedDict(TypedDict):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    amount0_desired: UniswapIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict
    r"""The desired amount of the first token to deposit"""
    amount1_desired: UniswapIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict
    r"""The desired amount of the second token to deposit"""
    amount0_min: UniswapIncreaseLiquidityProvisionParamsAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: UniswapIncreaseLiquidityProvisionParamsAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    action_type: Literal["UNISWAP_ADD_LIQUIDITY"]


class UniswapIncreaseLiquidityProvisionParams(BaseModel):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    amount0_desired: UniswapIncreaseLiquidityProvisionParamsAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: UniswapIncreaseLiquidityProvisionParamsAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: UniswapIncreaseLiquidityProvisionParamsAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: UniswapIncreaseLiquidityProvisionParamsAmount1Min
    r"""The minimum amount of the second token to deposit"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_ADD_LIQUIDITY"]],
            AfterValidator(validate_const("UNISWAP_ADD_LIQUIDITY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_ADD_LIQUIDITY"
