"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .feeenum import FeeEnum
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


UniswapBuyExactlyParamsAmountOutTypedDict = TypeAliasType(
    "UniswapBuyExactlyParamsAmountOutTypedDict", Union[float, str]
)
r"""The amount of 'token_out' to buy."""


UniswapBuyExactlyParamsAmountOut = TypeAliasType(
    "UniswapBuyExactlyParamsAmountOut", Union[float, str]
)
r"""The amount of 'token_out' to buy."""


class UniswapBuyExactlyParamsTypedDict(TypedDict):
    token_in: str
    r"""The symbol or address of the token to swap from.."""
    token_out: str
    r"""The symbol or address of the token to swap to.."""
    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """
    amount_out: UniswapBuyExactlyParamsAmountOutTypedDict
    r"""The amount of 'token_out' to buy."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""
    action_type: Literal["UNISWAP_BUY_EXACTLY"]


class UniswapBuyExactlyParams(BaseModel):
    token_in: str
    r"""The symbol or address of the token to swap from.."""

    token_out: str
    r"""The symbol or address of the token to swap to.."""

    fee: FeeEnum
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    amount_out: UniswapBuyExactlyParamsAmountOut
    r"""The amount of 'token_out' to buy."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNISWAP_BUY_EXACTLY"]],
            AfterValidator(validate_const("UNISWAP_BUY_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNISWAP_BUY_EXACTLY"
