"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


TokenTransferRequestAmountTypedDict = TypeAliasType(
    "TokenTransferRequestAmountTypedDict", Union[float, str]
)
r"""Amount of token to transfer"""


TokenTransferRequestAmount = TypeAliasType(
    "TokenTransferRequestAmount", Union[float, str]
)
r"""Amount of token to transfer"""


class TokenTransferRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class TokenTransferRequestTypedDict(TypedDict):
    r"""Request model for transferring ETH or ERC20 tokens."""

    to: str
    r"""The recipient of the tokens."""
    token: str
    r"""The symbol or address of the token to transfer."""
    amount: TokenTransferRequestAmountTypedDict
    r"""Amount of token to transfer"""
    chain: TokenTransferRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["TOKEN_TRANSFER"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class TokenTransferRequest(BaseModel):
    r"""Request model for transferring ETH or ERC20 tokens."""

    to: str
    r"""The recipient of the tokens."""

    token: str
    r"""The symbol or address of the token to transfer."""

    amount: TokenTransferRequestAmount
    r"""Amount of token to transfer"""

    chain: TokenTransferRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["TOKEN_TRANSFER"]],
            AfterValidator(validate_const("TOKEN_TRANSFER")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "TOKEN_TRANSFER"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
