"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


TokenTransferParamsAmountTypedDict = TypeAliasType(
    "TokenTransferParamsAmountTypedDict", Union[float, str]
)
r"""Amount of token to transfer"""


TokenTransferParamsAmount = TypeAliasType(
    "TokenTransferParamsAmount", Union[float, str]
)
r"""Amount of token to transfer"""


class TokenTransferParamsTypedDict(TypedDict):
    r"""Parameters model for transferring ETH or ERC20 tokens."""

    to: str
    r"""The recipient of the tokens."""
    token: str
    r"""The symbol or address of the token to transfer."""
    amount: TokenTransferParamsAmountTypedDict
    r"""Amount of token to transfer"""
    action_type: Literal["TOKEN_TRANSFER"]


class TokenTransferParams(BaseModel):
    r"""Parameters model for transferring ETH or ERC20 tokens."""

    to: str
    r"""The recipient of the tokens."""

    token: str
    r"""The symbol or address of the token to transfer."""

    amount: TokenTransferParamsAmount
    r"""Amount of token to transfer"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["TOKEN_TRANSFER"]],
            AfterValidator(validate_const("TOKEN_TRANSFER")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "TOKEN_TRANSFER"
