"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reserve import Reserve, ReserveTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class SwapBorrowRateTypedDict(TypedDict):
    id: str
    r"""The id of a historical transaction on aave"""
    timestamp: int
    r"""Timestamp in unix time"""
    tx_hash: str
    r"""Transaction hash. You can paste these into the search bar on etherscan"""
    borrow_rate_mode_from: int
    borrow_rate_mode_to: int
    variable_borrow_rate: int
    stable_borrow_rate: int
    reserve: ReserveTypedDict
    block: int
    action: Literal["SwapBorrowRate"]


class SwapBorrowRate(BaseModel):
    id: str
    r"""The id of a historical transaction on aave"""

    timestamp: int
    r"""Timestamp in unix time"""

    tx_hash: Annotated[str, pydantic.Field(alias="txHash")]
    r"""Transaction hash. You can paste these into the search bar on etherscan"""

    borrow_rate_mode_from: Annotated[int, pydantic.Field(alias="borrowRateModeFrom")]

    borrow_rate_mode_to: Annotated[int, pydantic.Field(alias="borrowRateModeTo")]

    variable_borrow_rate: Annotated[int, pydantic.Field(alias="variableBorrowRate")]

    stable_borrow_rate: Annotated[int, pydantic.Field(alias="stableBorrowRate")]

    reserve: Reserve

    block: int

    ACTION: Annotated[
        Annotated[
            Literal["SwapBorrowRate"], AfterValidator(validate_const("SwapBorrowRate"))
        ],
        pydantic.Field(alias="action"),
    ] = "SwapBorrowRate"
