"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class SkySellRequestTokenOut(str, Enum):
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""

    DAI = "DAI"
    USDC = "USDC"


SkySellRequestAmountTypedDict = TypeAliasType(
    "SkySellRequestAmountTypedDict", Union[float, str]
)
r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""


SkySellRequestAmount = TypeAliasType("SkySellRequestAmount", Union[float, str])
r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""


class SkySellRequestChain(str, Enum):
    ETHEREUM = "ethereum"


class SkySellRequestTypedDict(TypedDict):
    token_out: SkySellRequestTokenOut
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""
    amount: SkySellRequestAmountTypedDict
    r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""
    chain: SkySellRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["SKY_SELL"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class SkySellRequest(BaseModel):
    token_out: SkySellRequestTokenOut
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""

    amount: SkySellRequestAmount
    r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""

    chain: SkySellRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SKY_SELL"]], AfterValidator(validate_const("SKY_SELL"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "SKY_SELL"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
