"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class SkySellParamsTokenOut(str, Enum):
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""

    DAI = "DAI"
    USDC = "USDC"


SkySellParamsAmountTypedDict = TypeAliasType(
    "SkySellParamsAmountTypedDict", Union[float, str]
)
r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""


SkySellParamsAmount = TypeAliasType("SkySellParamsAmount", Union[float, str])
r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""


class SkySellParamsTypedDict(TypedDict):
    token_out: SkySellParamsTokenOut
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""
    amount: SkySellParamsAmountTypedDict
    r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""
    action_type: Literal["SKY_SELL"]


class SkySellParams(BaseModel):
    token_out: SkySellParamsTokenOut
    r"""The token you would like to swap 1:1 with USDS. Choose from DAI or USDC."""

    amount: SkySellParamsAmount
    r"""The amount of USDS you would like to sell 1:1 for 'token_out'."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SKY_SELL"]], AfterValidator(validate_const("SKY_SELL"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "SKY_SELL"
