"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


SkyDepositParamsAmountTypedDict = TypeAliasType(
    "SkyDepositParamsAmountTypedDict", Union[float, str]
)
r"""The amount of USDS you would like to deposit for sUSDS to earn yield."""


SkyDepositParamsAmount = TypeAliasType("SkyDepositParamsAmount", Union[float, str])
r"""The amount of USDS you would like to deposit for sUSDS to earn yield."""


class SkyDepositParamsTypedDict(TypedDict):
    amount: SkyDepositParamsAmountTypedDict
    r"""The amount of USDS you would like to deposit for sUSDS to earn yield."""
    action_type: Literal["SKY_DEPOSIT"]
    receiver: NotRequired[Nullable[str]]
    r"""The address which will receive the sUSDS. Defaults to the sender."""


class SkyDepositParams(BaseModel):
    amount: SkyDepositParamsAmount
    r"""The amount of USDS you would like to deposit for sUSDS to earn yield."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SKY_DEPOSIT"]],
            AfterValidator(validate_const("SKY_DEPOSIT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "SKY_DEPOSIT"

    receiver: OptionalNullable[str] = UNSET
    r"""The address which will receive the sUSDS. Defaults to the sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "receiver"]
        nullable_fields = ["receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
