"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class SkyBuyRequestTokenIn(str, Enum):
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""

    DAI = "DAI"
    USDC = "USDC"


SkyBuyRequestAmountTypedDict = TypeAliasType(
    "SkyBuyRequestAmountTypedDict", Union[float, str]
)
r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""


SkyBuyRequestAmount = TypeAliasType("SkyBuyRequestAmount", Union[float, str])
r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""


class SkyBuyRequestChain(str, Enum):
    ETHEREUM = "ethereum"


class SkyBuyRequestTypedDict(TypedDict):
    token_in: SkyBuyRequestTokenIn
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""
    amount: SkyBuyRequestAmountTypedDict
    r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""
    chain: SkyBuyRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["SKY_BUY"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class SkyBuyRequest(BaseModel):
    token_in: SkyBuyRequestTokenIn
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""

    amount: SkyBuyRequestAmount
    r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""

    chain: SkyBuyRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SKY_BUY"]], AfterValidator(validate_const("SKY_BUY"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "SKY_BUY"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
