"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class SkyBuyParamsTokenIn(str, Enum):
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""

    DAI = "DAI"
    USDC = "USDC"


SkyBuyParamsAmountTypedDict = TypeAliasType(
    "SkyBuyParamsAmountTypedDict", Union[float, str]
)
r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""


SkyBuyParamsAmount = TypeAliasType("SkyBuyParamsAmount", Union[float, str])
r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""


class SkyBuyParamsTypedDict(TypedDict):
    token_in: SkyBuyParamsTokenIn
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""
    amount: SkyBuyParamsAmountTypedDict
    r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""
    action_type: Literal["SKY_BUY"]


class SkyBuyParams(BaseModel):
    token_in: SkyBuyParamsTokenIn
    r"""The token you would like to swap 1:1 for USDS. Choose from DAI or USDC."""

    amount: SkyBuyParamsAmount
    r"""The amount of USDS you would like to buy 1:1 with 'token_in'."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SKY_BUY"]], AfterValidator(validate_const("SKY_BUY"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "SKY_BUY"
