"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class SetAllowanceRequestContractEnum(str, Enum):
    AAVE_V3_POOL = "AaveV3Pool"
    AERODROME_BASIC_ROUTER = "AerodromeBasicRouter"
    AERODROME_SLIPSTREAM_ROUTER = "AerodromeSlipstreamRouter"
    AERODROME_SLIPSTREAM_NONFUNGIBLE_POSITION_MANAGER = (
        "AerodromeSlipstreamNonfungiblePositionManager"
    )
    UNISWAP_V3_ROUTER = "UniswapV3Router"
    UNISWAP_V3_NFT_POSITION_MANAGER = "UniswapV3NFTPositionManager"
    MORPHO_MARKET = "MorphoMarket"
    SKY_DAI_USDS_CONVERTER = "SkyDaiUsdsConverter"
    SKY_USDC_USDS_CONVERTER = "SkyUsdcUsdsConverter"
    SKY_USDS_VAULT = "SkyUsdsVault"
    PENDLE_ROUTER = "PendleRouter"
    ODOS_ROUTER = "OdosRouter"
    ETHENA_VAULT = "EthenaVault"


SetAllowanceRequestContractUnionTypedDict = TypeAliasType(
    "SetAllowanceRequestContractUnionTypedDict",
    Union[SetAllowanceRequestContractEnum, str],
)
r"""The name or address of the contract to set spending allowance for."""


SetAllowanceRequestContractUnion = TypeAliasType(
    "SetAllowanceRequestContractUnion", Union[SetAllowanceRequestContractEnum, str]
)
r"""The name or address of the contract to set spending allowance for."""


SetAllowanceRequestAmountTypedDict = TypeAliasType(
    "SetAllowanceRequestAmountTypedDict", Union[float, str]
)
r"""The amount to set the allowance to."""


SetAllowanceRequestAmount = TypeAliasType(
    "SetAllowanceRequestAmount", Union[float, str]
)
r"""The amount to set the allowance to."""


class SetAllowanceRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class SetAllowanceRequestTypedDict(TypedDict):
    r"""Request model for increasing token allowance for a contract."""

    token: str
    r"""The symbol or address of the token for which the allowance is set.."""
    contract: SetAllowanceRequestContractUnionTypedDict
    r"""The name or address of the contract to set spending allowance for."""
    amount: SetAllowanceRequestAmountTypedDict
    r"""The amount to set the allowance to."""
    chain: SetAllowanceRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["SET_ALLOWANCE"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class SetAllowanceRequest(BaseModel):
    r"""Request model for increasing token allowance for a contract."""

    token: str
    r"""The symbol or address of the token for which the allowance is set.."""

    contract: SetAllowanceRequestContractUnion
    r"""The name or address of the contract to set spending allowance for."""

    amount: SetAllowanceRequestAmount
    r"""The amount to set the allowance to."""

    chain: SetAllowanceRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SET_ALLOWANCE"]],
            AfterValidator(validate_const("SET_ALLOWANCE")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "SET_ALLOWANCE"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
