"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class SetAllowanceParamsContractEnum(str, Enum):
    AAVE_V3_POOL = "AaveV3Pool"
    AERODROME_BASIC_ROUTER = "AerodromeBasicRouter"
    AERODROME_SLIPSTREAM_ROUTER = "AerodromeSlipstreamRouter"
    AERODROME_SLIPSTREAM_NONFUNGIBLE_POSITION_MANAGER = (
        "AerodromeSlipstreamNonfungiblePositionManager"
    )
    UNISWAP_V3_ROUTER = "UniswapV3Router"
    UNISWAP_V3_NFT_POSITION_MANAGER = "UniswapV3NFTPositionManager"
    MORPHO_MARKET = "MorphoMarket"
    SKY_DAI_USDS_CONVERTER = "SkyDaiUsdsConverter"
    SKY_USDC_USDS_CONVERTER = "SkyUsdcUsdsConverter"
    SKY_USDS_VAULT = "SkyUsdsVault"
    PENDLE_ROUTER = "PendleRouter"
    ODOS_ROUTER = "OdosRouter"
    ETHENA_VAULT = "EthenaVault"


SetAllowanceParamsContractUnionTypedDict = TypeAliasType(
    "SetAllowanceParamsContractUnionTypedDict",
    Union[SetAllowanceParamsContractEnum, str],
)
r"""The name or address of the contract to set spending allowance for."""


SetAllowanceParamsContractUnion = TypeAliasType(
    "SetAllowanceParamsContractUnion", Union[SetAllowanceParamsContractEnum, str]
)
r"""The name or address of the contract to set spending allowance for."""


SetAllowanceParamsAmountTypedDict = TypeAliasType(
    "SetAllowanceParamsAmountTypedDict", Union[float, str]
)
r"""The amount to set the allowance to."""


SetAllowanceParamsAmount = TypeAliasType("SetAllowanceParamsAmount", Union[float, str])
r"""The amount to set the allowance to."""


class SetAllowanceParamsTypedDict(TypedDict):
    r"""Parameters model for setting the token allowance for a given contract."""

    token: str
    r"""The symbol or address of the token for which the allowance is set.."""
    contract: SetAllowanceParamsContractUnionTypedDict
    r"""The name or address of the contract to set spending allowance for."""
    amount: SetAllowanceParamsAmountTypedDict
    r"""The amount to set the allowance to."""
    action_type: Literal["SET_ALLOWANCE"]


class SetAllowanceParams(BaseModel):
    r"""Parameters model for setting the token allowance for a given contract."""

    token: str
    r"""The symbol or address of the token for which the allowance is set.."""

    contract: SetAllowanceParamsContractUnion
    r"""The name or address of the contract to set spending allowance for."""

    amount: SetAllowanceParamsAmount
    r"""The amount to set the allowance to."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["SET_ALLOWANCE"]],
            AfterValidator(validate_const("SET_ALLOWANCE")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "SET_ALLOWANCE"
