"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .operationtype import OperationType
from compass_api_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class SafeTxMessageTypedDict(TypedDict):
    r"""The message data for a Safe transaction."""

    to: str
    r"""Destination address"""
    value: str
    r"""Value in wei as a string"""
    data: str
    r"""Transaction data as hex string"""
    operation: OperationType
    r"""Safe operation types."""
    safe_tx_gas: str
    r"""Gas for the Safe transaction"""
    base_gas: str
    r"""Base gas costs"""
    gas_price: str
    r"""Gas price"""
    gas_token: str
    r"""Token address for gas payment"""
    refund_receiver: str
    r"""Address to receive gas refund"""
    nonce: str
    r"""Safe transaction nonce"""


class SafeTxMessage(BaseModel):
    r"""The message data for a Safe transaction."""

    to: str
    r"""Destination address"""

    value: str
    r"""Value in wei as a string"""

    data: str
    r"""Transaction data as hex string"""

    operation: OperationType
    r"""Safe operation types."""

    safe_tx_gas: Annotated[str, pydantic.Field(alias="safeTxGas")]
    r"""Gas for the Safe transaction"""

    base_gas: Annotated[str, pydantic.Field(alias="baseGas")]
    r"""Base gas costs"""

    gas_price: Annotated[str, pydantic.Field(alias="gasPrice")]
    r"""Gas price"""

    gas_token: Annotated[str, pydantic.Field(alias="gasToken")]
    r"""Token address for gas payment"""

    refund_receiver: Annotated[str, pydantic.Field(alias="refundReceiver")]
    r"""Address to receive gas refund"""

    nonce: str
    r"""Safe transaction nonce"""
