"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PendleTradeYtRequestAction(str, Enum):
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""

    BUY = "BUY"
    SELL = "SELL"


PendleTradeYtRequestAmountInTypedDict = TypeAliasType(
    "PendleTradeYtRequestAmountInTypedDict", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""


PendleTradeYtRequestAmountIn = TypeAliasType(
    "PendleTradeYtRequestAmountIn", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""


class PendleTradeYtRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class PendleTradeYtRequestTypedDict(TypedDict):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to trade."""
    action: PendleTradeYtRequestAction
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""
    token: str
    r"""TThe symbol or address of the token to trade YT with. For `action` set to `BUY`, this is the token to buy YT with. For `action` set to `SELL`, this is the token to sell YT for."""
    amount_in: PendleTradeYtRequestAmountInTypedDict
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    chain: PendleTradeYtRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["PENDLE_TRADE_YT"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class PendleTradeYtRequest(BaseModel):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to trade."""

    action: PendleTradeYtRequestAction
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""

    token: str
    r"""TThe symbol or address of the token to trade YT with. For `action` set to `BUY`, this is the token to buy YT with. For `action` set to `SELL`, this is the token to sell YT for."""

    amount_in: PendleTradeYtRequestAmountIn
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    chain: PendleTradeYtRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_TRADE_YT"]],
            AfterValidator(validate_const("PENDLE_TRADE_YT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_TRADE_YT"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
