"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class PendleTradeYtParamsAction(str, Enum):
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""

    BUY = "BUY"
    SELL = "SELL"


PendleTradeYtParamsAmountInTypedDict = TypeAliasType(
    "PendleTradeYtParamsAmountInTypedDict", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""


PendleTradeYtParamsAmountIn = TypeAliasType(
    "PendleTradeYtParamsAmountIn", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""


class PendleTradeYtParamsTypedDict(TypedDict):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to trade."""
    action: PendleTradeYtParamsAction
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""
    token: str
    r"""TThe symbol or address of the token to trade YT with. For `action` set to `BUY`, this is the token to buy YT with. For `action` set to `SELL`, this is the token to sell YT for."""
    amount_in: PendleTradeYtParamsAmountInTypedDict
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    action_type: Literal["PENDLE_TRADE_YT"]


class PendleTradeYtParams(BaseModel):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to trade."""

    action: PendleTradeYtParamsAction
    r"""Specifies the direction of the YT trade. Valid values are `BUY` (to buy YT) or `SELL` (to sell YT)."""

    token: str
    r"""TThe symbol or address of the token to trade YT with. For `action` set to `BUY`, this is the token to buy YT with. For `action` set to `SELL`, this is the token to sell YT for."""

    amount_in: PendleTradeYtParamsAmountIn
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy YT with. For `action` set to `SELL`, this is the amount in of YT to sell for `token`."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_TRADE_YT"]],
            AfterValidator(validate_const("PENDLE_TRADE_YT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_TRADE_YT"
