"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PendleTradePtRequestAction(str, Enum):
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""

    BUY = "BUY"
    SELL = "SELL"


PendleTradePtRequestAmountInTypedDict = TypeAliasType(
    "PendleTradePtRequestAmountInTypedDict", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""


PendleTradePtRequestAmountIn = TypeAliasType(
    "PendleTradePtRequestAmountIn", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""


class PendleTradePtRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class PendleTradePtRequestTypedDict(TypedDict):
    market_address: str
    r"""The address of the market identifying which Principal Token (PT) you would like to trade."""
    action: PendleTradePtRequestAction
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""
    token: str
    r"""TThe symbol or address of the token to trade PT with. For `action` set to `BUY`, this is the token to buy PT with. For `action` set to `SELL`, this is the token to sell PT for."""
    amount_in: PendleTradePtRequestAmountInTypedDict
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    chain: PendleTradePtRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["PENDLE_TRADE_PT"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class PendleTradePtRequest(BaseModel):
    market_address: str
    r"""The address of the market identifying which Principal Token (PT) you would like to trade."""

    action: PendleTradePtRequestAction
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""

    token: str
    r"""TThe symbol or address of the token to trade PT with. For `action` set to `BUY`, this is the token to buy PT with. For `action` set to `SELL`, this is the token to sell PT for."""

    amount_in: PendleTradePtRequestAmountIn
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    chain: PendleTradePtRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_TRADE_PT"]],
            AfterValidator(validate_const("PENDLE_TRADE_PT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_TRADE_PT"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
