"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class PendleTradePtParamsAction(str, Enum):
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""

    BUY = "BUY"
    SELL = "SELL"


PendleTradePtParamsAmountInTypedDict = TypeAliasType(
    "PendleTradePtParamsAmountInTypedDict", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""


PendleTradePtParamsAmountIn = TypeAliasType(
    "PendleTradePtParamsAmountIn", Union[float, str]
)
r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""


class PendleTradePtParamsTypedDict(TypedDict):
    market_address: str
    r"""The address of the market identifying which Principal Token (PT) you would like to trade."""
    action: PendleTradePtParamsAction
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""
    token: str
    r"""TThe symbol or address of the token to trade PT with. For `action` set to `BUY`, this is the token to buy PT with. For `action` set to `SELL`, this is the token to sell PT for."""
    amount_in: PendleTradePtParamsAmountInTypedDict
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    action_type: Literal["PENDLE_TRADE_PT"]


class PendleTradePtParams(BaseModel):
    market_address: str
    r"""The address of the market identifying which Principal Token (PT) you would like to trade."""

    action: PendleTradePtParamsAction
    r"""Specifies the direction of the PT trade. Valid values are `BUY` (to buy PT) or `SELL` (to sell PT)."""

    token: str
    r"""TThe symbol or address of the token to trade PT with. For `action` set to `BUY`, this is the token to buy PT with. For `action` set to `SELL`, this is the token to sell PT for."""

    amount_in: PendleTradePtParamsAmountIn
    r"""For `action` set to `BUY`, this is the amount in of `token` to buy PT with. For `action` set to `SELL`, this is the amount in of PT to sell for `token`."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_TRADE_PT"]],
            AfterValidator(validate_const("PENDLE_TRADE_PT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_TRADE_PT"
