"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PendleRedeemYieldRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class PendleRedeemYieldRequestTypedDict(TypedDict):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to claim yield from."""
    chain: PendleRedeemYieldRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["PENDLE_REDEEM_YIELD"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class PendleRedeemYieldRequest(BaseModel):
    market_address: str
    r"""The address of the market identifying which Yield Token (YT) you would like to claim yield from."""

    chain: PendleRedeemYieldRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_REDEEM_YIELD"]],
            AfterValidator(validate_const("PENDLE_REDEEM_YIELD")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_REDEEM_YIELD"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
