"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PendleManageLiquidityRequestAction(str, Enum):
    r"""Specifies the direction of the liquidity operation for the Pendle market. Valid values are `SUPPLY` (to add liquidity) or `WITHDRAW` (to remove liquidity)."""

    SUPPLY = "SUPPLY"
    WITHDRAW = "WITHDRAW"


PendleManageLiquidityRequestAmountInTypedDict = TypeAliasType(
    "PendleManageLiquidityRequestAmountInTypedDict", Union[float, str]
)
r"""For `action` set to `SUPPLY`, this is the amount in of `token` to add as liquidity in exchange for Liquidity Provider (LP) tokens. For `action` set to `WITHDRAW`, this is the amount in of LP tokens to redeem for `token`."""


PendleManageLiquidityRequestAmountIn = TypeAliasType(
    "PendleManageLiquidityRequestAmountIn", Union[float, str]
)
r"""For `action` set to `SUPPLY`, this is the amount in of `token` to add as liquidity in exchange for Liquidity Provider (LP) tokens. For `action` set to `WITHDRAW`, this is the amount in of LP tokens to redeem for `token`."""


class PendleManageLiquidityRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class PendleManageLiquidityRequestTypedDict(TypedDict):
    market_address: str
    r"""The address identifying which Pendle Market you would like to add liquidity to."""
    action: PendleManageLiquidityRequestAction
    r"""Specifies the direction of the liquidity operation for the Pendle market. Valid values are `SUPPLY` (to add liquidity) or `WITHDRAW` (to remove liquidity)."""
    token: str
    r"""The symbol or address of the token to manage liquidity with. For `action` set to `SUPPLY`, this is the token to add as liquidity. For `action` set to `WITHDRAW`, this is the token to remove from liquidity."""
    amount_in: PendleManageLiquidityRequestAmountInTypedDict
    r"""For `action` set to `SUPPLY`, this is the amount in of `token` to add as liquidity in exchange for Liquidity Provider (LP) tokens. For `action` set to `WITHDRAW`, this is the amount in of LP tokens to redeem for `token`."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    chain: PendleManageLiquidityRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["PENDLE_MANAGE_LIQUIDITY"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class PendleManageLiquidityRequest(BaseModel):
    market_address: str
    r"""The address identifying which Pendle Market you would like to add liquidity to."""

    action: PendleManageLiquidityRequestAction
    r"""Specifies the direction of the liquidity operation for the Pendle market. Valid values are `SUPPLY` (to add liquidity) or `WITHDRAW` (to remove liquidity)."""

    token: str
    r"""The symbol or address of the token to manage liquidity with. For `action` set to `SUPPLY`, this is the token to add as liquidity. For `action` set to `WITHDRAW`, this is the token to remove from liquidity."""

    amount_in: PendleManageLiquidityRequestAmountIn
    r"""For `action` set to `SUPPLY`, this is the amount in of `token` to add as liquidity in exchange for Liquidity Provider (LP) tokens. For `action` set to `WITHDRAW`, this is the amount in of LP tokens to redeem for `token`."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    chain: PendleManageLiquidityRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["PENDLE_MANAGE_LIQUIDITY"]],
            AfterValidator(validate_const("PENDLE_MANAGE_LIQUIDITY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "PENDLE_MANAGE_LIQUIDITY"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
