"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .compass_api_backend_v1_models_pendle_read_response_market_userposition import (
    CompassAPIBackendV1ModelsPendleReadResponseMarketUserPosition,
    CompassAPIBackendV1ModelsPendleReadResponseMarketUserPositionTypedDict,
)
from .markettokens import MarketTokens, MarketTokensTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class PendleGetMarketResponseTypedDict(TypedDict):
    market_address: str
    r"""The address of the market."""
    implied_apy: str
    r"""The implied APY of the market."""
    maturity_date: datetime
    r"""The maturity date of the market. ISO 8601 format. UTC timezone."""
    tokens: MarketTokensTypedDict
    user_position: NotRequired[
        Nullable[CompassAPIBackendV1ModelsPendleReadResponseMarketUserPositionTypedDict]
    ]
    r"""The user's position in the market."""


class PendleGetMarketResponse(BaseModel):
    market_address: str
    r"""The address of the market."""

    implied_apy: str
    r"""The implied APY of the market."""

    maturity_date: datetime
    r"""The maturity date of the market. ISO 8601 format. UTC timezone."""

    tokens: MarketTokens

    user_position: OptionalNullable[
        CompassAPIBackendV1ModelsPendleReadResponseMarketUserPosition
    ] = UNSET
    r"""The user's position in the market."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["user_position"]
        nullable_fields = ["user_position"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
