"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OdosSwapRequestAmountInTypedDict = TypeAliasType(
    "OdosSwapRequestAmountInTypedDict", Union[float, str]
)
r"""The amount of token_in to be sold."""


OdosSwapRequestAmountIn = TypeAliasType("OdosSwapRequestAmountIn", Union[float, str])
r"""The amount of token_in to be sold."""


class OdosSwapRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class OdosSwapRequestTypedDict(TypedDict):
    token_in: str
    r"""The symbol or address of the token that is to be sold."""
    token_out: str
    r"""The symbol or address of the token that is to be bought."""
    amount_in: OdosSwapRequestAmountInTypedDict
    r"""The amount of token_in to be sold."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    chain: OdosSwapRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["ODOS_SWAP"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class OdosSwapRequest(BaseModel):
    token_in: str
    r"""The symbol or address of the token that is to be sold."""

    token_out: str
    r"""The symbol or address of the token that is to be bought."""

    amount_in: OdosSwapRequestAmountIn
    r"""The amount of token_in to be sold."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    chain: OdosSwapRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["ODOS_SWAP"]], AfterValidator(validate_const("ODOS_SWAP"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "ODOS_SWAP"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
