"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


OdosSwapParamsAmountInTypedDict = TypeAliasType(
    "OdosSwapParamsAmountInTypedDict", Union[float, str]
)
r"""The amount of token_in to be sold."""


OdosSwapParamsAmountIn = TypeAliasType("OdosSwapParamsAmountIn", Union[float, str])
r"""The amount of token_in to be sold."""


class OdosSwapParamsTypedDict(TypedDict):
    token_in: str
    r"""The symbol or address of the token that is to be sold."""
    token_out: str
    r"""The symbol or address of the token that is to be bought."""
    amount_in: OdosSwapParamsAmountInTypedDict
    r"""The amount of token_in to be sold."""
    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""
    action_type: Literal["ODOS_SWAP"]


class OdosSwapParams(BaseModel):
    token_in: str
    r"""The symbol or address of the token that is to be sold."""

    token_out: str
    r"""The symbol or address of the token that is to be bought."""

    amount_in: OdosSwapParamsAmountIn
    r"""The amount of token_in to be sold."""

    max_slippage_percent: float
    r"""The maximum slippage allowed in percent. e.g. `1` means `1%` slippage allowed."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["ODOS_SWAP"]], AfterValidator(validate_const("ODOS_SWAP"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "ODOS_SWAP"
