"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .signedauthorization import SignedAuthorization, SignedAuthorizationTypedDict
from .useroperation import UserOperation, UserOperationTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class MulticallExecuteRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class MulticallExecuteRequestTypedDict(TypedDict):
    r"""Request model for executing a multicall."""

    chain: MulticallExecuteRequestChain
    sender: str
    r"""The address of the transaction sender."""
    actions: List[UserOperationTypedDict]
    r"""List of possible actions for multicall"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
    signed_authorization: NotRequired[Nullable[SignedAuthorizationTypedDict]]
    r"""EIP-7702 authorization"""


class MulticallExecuteRequest(BaseModel):
    r"""Request model for executing a multicall."""

    chain: MulticallExecuteRequestChain

    sender: str
    r"""The address of the transaction sender."""

    actions: List[UserOperation]
    r"""List of possible actions for multicall"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    signed_authorization: OptionalNullable[SignedAuthorization] = UNSET
    r"""EIP-7702 authorization"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["estimate_gas", "signed_authorization"]
        nullable_fields = ["signed_authorization"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
