"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MorphoWithdrawParamsTypedDict(TypedDict):
    vault_address: str
    r"""The vault address you are withdrawing from."""
    amount: Any
    r"""The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn."""
    action_type: Literal["MORPHO_WITHDRAW"]
    receiver: NotRequired[Nullable[str]]
    r"""The address which will receive the tokens withdrawn. Defaults to the sender."""


class MorphoWithdrawParams(BaseModel):
    vault_address: str
    r"""The vault address you are withdrawing from."""

    amount: Any
    r"""The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["MORPHO_WITHDRAW"]],
            AfterValidator(validate_const("MORPHO_WITHDRAW")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "MORPHO_WITHDRAW"

    receiver: OptionalNullable[str] = UNSET
    r"""The address which will receive the tokens withdrawn. Defaults to the sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "receiver"]
        nullable_fields = ["receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
