"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MorphoWithdrawCollateralParamsAmountTypedDict = TypeAliasType(
    "MorphoWithdrawCollateralParamsAmountTypedDict", Union[float, str]
)
r"""Amount of the token to supply to the market as collateral."""


MorphoWithdrawCollateralParamsAmount = TypeAliasType(
    "MorphoWithdrawCollateralParamsAmount", Union[float, str]
)
r"""Amount of the token to supply to the market as collateral."""


class MorphoWithdrawCollateralParamsTypedDict(TypedDict):
    amount: MorphoWithdrawCollateralParamsAmountTypedDict
    r"""Amount of the token to supply to the market as collateral."""
    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""
    action_type: Literal["MORPHO_WITHDRAW_COLLATERAL"]
    on_behalf_of: NotRequired[Nullable[str]]
    r"""The address on behalf of whom the withdraw is made. Defaults to sender."""
    receiver: NotRequired[Nullable[str]]
    r"""The address where the withdrawn collateral will be received. Defaults to sender."""


class MorphoWithdrawCollateralParams(BaseModel):
    amount: MorphoWithdrawCollateralParamsAmount
    r"""Amount of the token to supply to the market as collateral."""

    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["MORPHO_WITHDRAW_COLLATERAL"]],
            AfterValidator(validate_const("MORPHO_WITHDRAW_COLLATERAL")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "MORPHO_WITHDRAW_COLLATERAL"

    on_behalf_of: OptionalNullable[str] = UNSET
    r"""The address on behalf of whom the withdraw is made. Defaults to sender."""

    receiver: OptionalNullable[str] = UNSET
    r"""The address where the withdrawn collateral will be received. Defaults to sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "on_behalf_of", "receiver"]
        nullable_fields = ["on_behalf_of", "receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
