"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MorphoRepayRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class MorphoRepayRequestTypedDict(TypedDict):
    amount: Any
    r"""Amount of the token to repay to the market. If set to 'ALL', all debt plus interest will be paid back if the user has a sufficient token balance in their wallet."""
    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""
    chain: MorphoRepayRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["MORPHO_REPAY"]
    on_behalf_of: NotRequired[Nullable[str]]
    r"""The address on behalf of whom the repayment is made. Defaults to sender."""
    callback_data: NotRequired[Nullable[bytes]]
    r"""An optional field for callback byte data that will be triggered upon successful repaying of debt."""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class MorphoRepayRequest(BaseModel):
    amount: Any
    r"""Amount of the token to repay to the market. If set to 'ALL', all debt plus interest will be paid back if the user has a sufficient token balance in their wallet."""

    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""

    chain: MorphoRepayRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["MORPHO_REPAY"]],
            AfterValidator(validate_const("MORPHO_REPAY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "MORPHO_REPAY"

    on_behalf_of: OptionalNullable[str] = UNSET
    r"""The address on behalf of whom the repayment is made. Defaults to sender."""

    callback_data: OptionalNullable[bytes] = UNSET
    r"""An optional field for callback byte data that will be triggered upon successful repaying of debt."""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "action_type",
            "on_behalf_of",
            "callback_data",
            "estimate_gas",
        ]
        nullable_fields = ["on_behalf_of", "callback_data"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
