"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .compass_api_backend_v1_models_morpho_read_response_get_markets_asset import (
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAsset,
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAssetTypedDict,
)
from .compass_api_backend_v1_models_morpho_read_response_get_markets_marketstate import (
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsMarketState,
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsMarketStateTypedDict,
)
from .weeklyapys import WeeklyApys, WeeklyApysTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class MorphoMarketTypedDict(TypedDict):
    unique_key: str
    lltv: int
    oracle_address: str
    irm_address: str
    state: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsMarketStateTypedDict
    weekly_apys: WeeklyApysTypedDict
    loan_asset: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAssetTypedDict
    collateral_asset: NotRequired[
        Nullable[CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAssetTypedDict]
    ]


class MorphoMarket(BaseModel):
    unique_key: Annotated[str, pydantic.Field(alias="uniqueKey")]

    lltv: int

    oracle_address: Annotated[str, pydantic.Field(alias="oracleAddress")]

    irm_address: Annotated[str, pydantic.Field(alias="irmAddress")]

    state: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsMarketState

    weekly_apys: Annotated[WeeklyApys, pydantic.Field(alias="weeklyApys")]

    loan_asset: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAsset,
        pydantic.Field(alias="loanAsset"),
    ]

    collateral_asset: Annotated[
        OptionalNullable[CompassAPIBackendV1ModelsMorphoReadResponseGetMarketsAsset],
        pydantic.Field(alias="collateralAsset"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["collateralAsset"]
        nullable_fields = ["collateralAsset"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
