"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .compass_api_backend_v1_models_morpho_read_response_get_market_apydata import (
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict,
)
from .compass_api_backend_v1_models_morpho_read_response_get_market_asset import (
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAsset,
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAssetTypedDict,
)
from .compass_api_backend_v1_models_morpho_read_response_get_market_marketstate import (
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketMarketState,
    CompassAPIBackendV1ModelsMorphoReadResponseGetMarketMarketStateTypedDict,
)
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class MorphoGetMarketResponseTypedDict(TypedDict):
    whitelisted: bool
    r"""Whether the market is whitelisted or not."""
    lltv: str
    r"""(Liquidation Loan-To-Value) Maximum borrowing percentage before liquidation risk. Scaled by 1e18."""
    daily_apys: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict
    weekly_apys: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict
    monthly_apys: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict
    yearly_apys: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict
    all_time_apys: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyDataTypedDict
    loan_asset: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAssetTypedDict
    state: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketMarketStateTypedDict
    collateral_asset: NotRequired[
        Nullable[CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAssetTypedDict]
    ]
    r"""Data of the underlying collateral asset of the market."""


class MorphoGetMarketResponse(BaseModel):
    whitelisted: bool
    r"""Whether the market is whitelisted or not."""

    lltv: str
    r"""(Liquidation Loan-To-Value) Maximum borrowing percentage before liquidation risk. Scaled by 1e18."""

    daily_apys: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
        pydantic.Field(alias="dailyApys"),
    ]

    weekly_apys: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
        pydantic.Field(alias="weeklyApys"),
    ]

    monthly_apys: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
        pydantic.Field(alias="monthlyApys"),
    ]

    yearly_apys: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
        pydantic.Field(alias="yearlyApys"),
    ]

    all_time_apys: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketApyData,
        pydantic.Field(alias="allTimeApys"),
    ]

    loan_asset: Annotated[
        CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAsset,
        pydantic.Field(alias="loanAsset"),
    ]

    state: CompassAPIBackendV1ModelsMorphoReadResponseGetMarketMarketState

    collateral_asset: Annotated[
        OptionalNullable[CompassAPIBackendV1ModelsMorphoReadResponseGetMarketAsset],
        pydantic.Field(alias="collateralAsset"),
    ] = UNSET
    r"""Data of the underlying collateral asset of the market."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["collateralAsset"]
        nullable_fields = ["collateralAsset"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
