"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MorphoDepositParamsAmountTypedDict = TypeAliasType(
    "MorphoDepositParamsAmountTypedDict", Union[float, str]
)
r"""The amount of tokens to deposit into the vault."""


MorphoDepositParamsAmount = TypeAliasType(
    "MorphoDepositParamsAmount", Union[float, str]
)
r"""The amount of tokens to deposit into the vault."""


class MorphoDepositParamsTypedDict(TypedDict):
    vault_address: str
    r"""The vault address you are depositing to."""
    amount: MorphoDepositParamsAmountTypedDict
    r"""The amount of tokens to deposit into the vault."""
    action_type: Literal["MORPHO_DEPOSIT"]
    receiver: NotRequired[Nullable[str]]
    r"""The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender."""


class MorphoDepositParams(BaseModel):
    vault_address: str
    r"""The vault address you are depositing to."""

    amount: MorphoDepositParamsAmount
    r"""The amount of tokens to deposit into the vault."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["MORPHO_DEPOSIT"]],
            AfterValidator(validate_const("MORPHO_DEPOSIT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "MORPHO_DEPOSIT"

    receiver: OptionalNullable[str] = UNSET
    r"""The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "receiver"]
        nullable_fields = ["receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
