"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MorphoBorrowRequestAmountTypedDict = TypeAliasType(
    "MorphoBorrowRequestAmountTypedDict", Union[float, str]
)
r"""Amount of the token to borrow from the market."""


MorphoBorrowRequestAmount = TypeAliasType(
    "MorphoBorrowRequestAmount", Union[float, str]
)
r"""Amount of the token to borrow from the market."""


class MorphoBorrowRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class MorphoBorrowRequestTypedDict(TypedDict):
    amount: MorphoBorrowRequestAmountTypedDict
    r"""Amount of the token to borrow from the market."""
    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""
    chain: MorphoBorrowRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["MORPHO_BORROW"]
    on_behalf_of: NotRequired[Nullable[str]]
    r"""The address where the collateral is borrowed against. Defaults to sender."""
    receiver: NotRequired[Nullable[str]]
    r"""The address of the receiver of the tokens borrowed. Defaults to the transaction sender."""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class MorphoBorrowRequest(BaseModel):
    amount: MorphoBorrowRequestAmount
    r"""Amount of the token to borrow from the market."""

    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""

    chain: MorphoBorrowRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["MORPHO_BORROW"]],
            AfterValidator(validate_const("MORPHO_BORROW")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "MORPHO_BORROW"

    on_behalf_of: OptionalNullable[str] = UNSET
    r"""The address where the collateral is borrowed against. Defaults to sender."""

    receiver: OptionalNullable[str] = UNSET
    r"""The address of the receiver of the tokens borrowed. Defaults to the transaction sender."""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "on_behalf_of", "receiver", "estimate_gas"]
        nullable_fields = ["on_behalf_of", "receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
