"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .unsignedtransaction import UnsignedTransaction, UnsignedTransactionTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class MintPrepareReadyResponseTypedDict(TypedDict):
    r"""Response when attestation is ready and mint transaction can be built.

    Returned with 200 OK status code. Contains an unsigned transaction that calls
    receiveMessage on the MessageTransmitter contract.
    """

    bridge_id: str
    r"""The bridge identifier."""
    transaction: UnsignedTransactionTypedDict
    status: Literal["ready"]
    r"""Indicates the attestation is ready and mint transaction is available."""


class MintPrepareReadyResponse(BaseModel):
    r"""Response when attestation is ready and mint transaction can be built.

    Returned with 200 OK status code. Contains an unsigned transaction that calls
    receiveMessage on the MessageTransmitter contract.
    """

    bridge_id: str
    r"""The bridge identifier."""

    transaction: UnsignedTransaction

    STATUS: Annotated[
        Annotated[Optional[Literal["ready"]], AfterValidator(validate_const("ready"))],
        pydantic.Field(alias="status"),
    ] = "ready"
    r"""Indicates the attestation is ready and mint transaction is available."""
