"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class MintPreparePendingResponseTypedDict(TypedDict):
    r"""Response when attestation is not yet ready.

    Returned with 202 Accepted status code. The client should either:
    - Connect to the SSE stream for real-time updates
    - Poll the status endpoint periodically
    - Call /mint/prepare again after some time
    """

    bridge_id: str
    r"""The bridge identifier."""
    message_hash: str
    r"""The CCTP message hash being polled for attestation."""
    sse_url: str
    r"""SSE endpoint URL for real-time attestation updates."""
    status_url: str
    r"""HTTP endpoint URL for polling bridge status."""
    estimated_wait_seconds: int
    r"""Estimated wait time in seconds. Fast mode is typically ~30 seconds, standard mode is 15-19 minutes."""
    status: Literal["pending"]
    r"""Indicates the attestation is still being awaited."""


class MintPreparePendingResponse(BaseModel):
    r"""Response when attestation is not yet ready.

    Returned with 202 Accepted status code. The client should either:
    - Connect to the SSE stream for real-time updates
    - Poll the status endpoint periodically
    - Call /mint/prepare again after some time
    """

    bridge_id: str
    r"""The bridge identifier."""

    message_hash: str
    r"""The CCTP message hash being polled for attestation."""

    sse_url: str
    r"""SSE endpoint URL for real-time attestation updates."""

    status_url: str
    r"""HTTP endpoint URL for polling bridge status."""

    estimated_wait_seconds: int
    r"""Estimated wait time in seconds. Fast mode is typically ~30 seconds, standard mode is 15-19 minutes."""

    STATUS: Annotated[
        Annotated[
            Optional[Literal["pending"]], AfterValidator(validate_const("pending"))
        ],
        pydantic.Field(alias="status"),
    ] = "pending"
    r"""Indicates the attestation is still being awaited."""
