"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MintPrepareCompletedResponseTypedDict(TypedDict):
    r"""Response when the bridge has already been completed (minted).

    This means someone has already called receiveMessage on the destination chain to
    mint the USDC. No further action is required.
    """

    bridge_id: str
    r"""The bridge identifier."""
    status: Literal["completed"]
    r"""Indicates the bridge has already been completed and USDC minted."""
    message: NotRequired[str]
    r"""Human-readable message explaining the status."""


class MintPrepareCompletedResponse(BaseModel):
    r"""Response when the bridge has already been completed (minted).

    This means someone has already called receiveMessage on the destination chain to
    mint the USDC. No further action is required.
    """

    bridge_id: str
    r"""The bridge identifier."""

    STATUS: Annotated[
        Annotated[
            Optional[Literal["completed"]], AfterValidator(validate_const("completed"))
        ],
        pydantic.Field(alias="status"),
    ] = "completed"
    r"""Indicates the bridge has already been completed and USDC minted."""

    message: Optional[str] = None
    r"""Human-readable message explaining the status."""
