"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reserve import Reserve, ReserveTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class LiquidationCallTypedDict(TypedDict):
    id: str
    r"""The id of a historical transaction on aave"""
    timestamp: int
    r"""Timestamp in unix time"""
    tx_hash: str
    r"""Transaction hash. You can paste these into the search bar on etherscan"""
    collateral_amount: float
    collateral_reserve: ReserveTypedDict
    principal_amount: float
    principal_reserve: ReserveTypedDict
    collateral_asset_price_usd: float
    borrow_asset_price_usd: float
    block: int
    action: Literal["LiquidationCall"]


class LiquidationCall(BaseModel):
    id: str
    r"""The id of a historical transaction on aave"""

    timestamp: int
    r"""Timestamp in unix time"""

    tx_hash: Annotated[str, pydantic.Field(alias="txHash")]
    r"""Transaction hash. You can paste these into the search bar on etherscan"""

    collateral_amount: Annotated[float, pydantic.Field(alias="collateralAmount")]

    collateral_reserve: Annotated[Reserve, pydantic.Field(alias="collateralReserve")]

    principal_amount: Annotated[float, pydantic.Field(alias="principalAmount")]

    principal_reserve: Annotated[Reserve, pydantic.Field(alias="principalReserve")]

    collateral_asset_price_usd: Annotated[
        float, pydantic.Field(alias="collateralAssetPriceUSD")
    ]

    borrow_asset_price_usd: Annotated[
        float, pydantic.Field(alias="borrowAssetPriceUSD")
    ]

    block: int

    ACTION: Annotated[
        Annotated[
            Literal["LiquidationCall"],
            AfterValidator(validate_const("LiquidationCall")),
        ],
        pydantic.Field(alias="action"),
    ] = "LiquidationCall"
