"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from enum import Enum
from typing import Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


FeeAmountTypedDict = TypeAliasType("FeeAmountTypedDict", Union[float, str])
r"""The fee amount. If `denomination` is 'PERCENTAGE', this is a percentage of the transaction amount (e.g., 1.5 for 1.5%). If `denomination` is 'FIXED', this is a fixed amount in token units (e.g., 0.1 for 0.1 tokens)."""


FeeAmount = TypeAliasType("FeeAmount", Union[float, str])
r"""The fee amount. If `denomination` is 'PERCENTAGE', this is a percentage of the transaction amount (e.g., 1.5 for 1.5%). If `denomination` is 'FIXED', this is a fixed amount in token units (e.g., 0.1 for 0.1 tokens)."""


class Denomination(str, Enum):
    r"""The unit type for the fee amount. Use 'PERCENTAGE' for a percentage-based fee (e.g., 1.5 means 1.5% of the transaction amount) or 'FIXED' for a fixed token amount (e.g., 0.1 means 0.1 tokens)."""

    PERCENTAGE = "PERCENTAGE"
    FIXED = "FIXED"


class FeeTypedDict(TypedDict):
    recipient: str
    r"""The wallet address that will receive the fee."""
    amount: FeeAmountTypedDict
    r"""The fee amount. If `denomination` is 'PERCENTAGE', this is a percentage of the transaction amount (e.g., 1.5 for 1.5%). If `denomination` is 'FIXED', this is a fixed amount in token units (e.g., 0.1 for 0.1 tokens)."""
    denomination: NotRequired[Denomination]
    r"""The unit type for the fee amount. Use 'PERCENTAGE' for a percentage-based fee (e.g., 1.5 means 1.5% of the transaction amount) or 'FIXED' for a fixed token amount (e.g., 0.1 means 0.1 tokens)."""


class Fee(BaseModel):
    recipient: str
    r"""The wallet address that will receive the fee."""

    amount: FeeAmount
    r"""The fee amount. If `denomination` is 'PERCENTAGE', this is a percentage of the transaction amount (e.g., 1.5 for 1.5%). If `denomination` is 'FIXED', this is a fixed amount in token units (e.g., 0.1 for 0.1 tokens)."""

    denomination: Optional[Denomination] = None
    r"""The unit type for the fee amount. Use 'PERCENTAGE' for a percentage-based fee (e.g., 1.5 means 1.5% of the transaction amount) or 'FIXED' for a fixed token amount (e.g., 0.1 means 0.1 tokens)."""
