"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Any, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EthenaRequestToWithdrawRequestChain(str, Enum):
    ETHEREUM = "ethereum"


class EthenaRequestToWithdrawRequestTypedDict(TypedDict):
    amount: Any
    r"""The amount of USDe to request to withdraw from Ethena's vault. If set to 'ALL', your total deposited USDe amount will be requested to be withdrawn."""
    chain: EthenaRequestToWithdrawRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["ETHENA_REQUEST_WITHDRAW"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class EthenaRequestToWithdrawRequest(BaseModel):
    amount: Any
    r"""The amount of USDe to request to withdraw from Ethena's vault. If set to 'ALL', your total deposited USDe amount will be requested to be withdrawn."""

    chain: EthenaRequestToWithdrawRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["ETHENA_REQUEST_WITHDRAW"]],
            AfterValidator(validate_const("ETHENA_REQUEST_WITHDRAW")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "ETHENA_REQUEST_WITHDRAW"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
