"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .apy import Apy, ApyTypedDict
from .compass_api_backend_v1_models_vaults_read_response_vault_userposition import (
    CompassAPIBackendV1ModelsVaultsReadResponseVaultUserPosition,
    CompassAPIBackendV1ModelsVaultsReadResponseVaultUserPositionTypedDict,
)
from .cooldownposition import CooldownPosition, CooldownPositionTypedDict
from .underlyingtoken import UnderlyingToken, UnderlyingTokenTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class EthenaGetVaultResponseTypedDict(TypedDict):
    name: str
    r"""Name of the vault."""
    symbol: str
    r"""Symbol of the vault."""
    decimals: int
    r"""Number of decimals used for the vault's share precision."""
    total_assets: str
    r"""Total amount of assets deposited in the vault."""
    total_supply: str
    r"""Total amount of shares issued from the vault."""
    share_price: str
    r"""The price of one vault share in terms of the underlying asset."""
    underlying_token: UnderlyingTokenTypedDict
    apy: ApyTypedDict
    cooldown_duration_days: int
    r"""The duration of days that must pass before a position can be withdrawn from the Ethena vault after a request to withdraw has been made."""
    user_position: NotRequired[
        Nullable[CompassAPIBackendV1ModelsVaultsReadResponseVaultUserPositionTypedDict]
    ]
    r"""The user's position in the vault."""
    cooldown_position: NotRequired[Nullable[CooldownPositionTypedDict]]
    r"""The user's cooldown position."""


class EthenaGetVaultResponse(BaseModel):
    name: str
    r"""Name of the vault."""

    symbol: str
    r"""Symbol of the vault."""

    decimals: int
    r"""Number of decimals used for the vault's share precision."""

    total_assets: str
    r"""Total amount of assets deposited in the vault."""

    total_supply: str
    r"""Total amount of shares issued from the vault."""

    share_price: str
    r"""The price of one vault share in terms of the underlying asset."""

    underlying_token: UnderlyingToken

    apy: Apy

    cooldown_duration_days: int
    r"""The duration of days that must pass before a position can be withdrawn from the Ethena vault after a request to withdraw has been made."""

    user_position: OptionalNullable[
        CompassAPIBackendV1ModelsVaultsReadResponseVaultUserPosition
    ] = UNSET
    r"""The user's position in the vault."""

    cooldown_position: OptionalNullable[CooldownPosition] = UNSET
    r"""The user's cooldown position."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["user_position", "cooldown_position"]
        nullable_fields = ["user_position", "cooldown_position"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
