"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


EthenaDepositParamsAmountTypedDict = TypeAliasType(
    "EthenaDepositParamsAmountTypedDict", Union[float, str]
)
r"""The amount of USDe to deposit into Ethena's vault."""


EthenaDepositParamsAmount = TypeAliasType(
    "EthenaDepositParamsAmount", Union[float, str]
)
r"""The amount of USDe to deposit into Ethena's vault."""


class EthenaDepositParamsTypedDict(TypedDict):
    amount: EthenaDepositParamsAmountTypedDict
    r"""The amount of USDe to deposit into Ethena's vault."""
    action_type: Literal["ETHENA_DEPOSIT"]
    receiver: NotRequired[Nullable[str]]
    r"""The address which will receive the shares (sUSDe) from Ethena's vault representing their proportional ownership of the vault's assets. Defaults to the sender."""


class EthenaDepositParams(BaseModel):
    amount: EthenaDepositParamsAmount
    r"""The amount of USDe to deposit into Ethena's vault."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["ETHENA_DEPOSIT"]],
            AfterValidator(validate_const("ETHENA_DEPOSIT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "ETHENA_DEPOSIT"

    receiver: OptionalNullable[str] = UNSET
    r"""The address which will receive the shares (sUSDe) from Ethena's vault representing their proportional ownership of the vault's assets. Defaults to the sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "receiver"]
        nullable_fields = ["receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
