"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chain import Chain
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


EarnTransferRequestAmountTypedDict = TypeAliasType(
    "EarnTransferRequestAmountTypedDict", Union[float, str]
)
r"""The amount of 'token' to transfer."""


EarnTransferRequestAmount = TypeAliasType(
    "EarnTransferRequestAmount", Union[float, str]
)
r"""The amount of 'token' to transfer."""


class EarnTransferRequestAction(str, Enum):
    r"""Whether you are depositing to or withdrawing from your earn account."""

    DEPOSIT = "DEPOSIT"
    WITHDRAW = "WITHDRAW"


class EarnTransferRequestTypedDict(TypedDict):
    owner: str
    r"""The owner's wallet address."""
    chain: Chain
    r"""The chain to use."""
    token: str
    r"""The token you would like to transfer."""
    amount: EarnTransferRequestAmountTypedDict
    r"""The amount of 'token' to transfer."""
    action: EarnTransferRequestAction
    r"""Whether you are depositing to or withdrawing from your earn account."""
    gas_sponsorship: NotRequired[bool]
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 signature data will be returned that must be signed by the `owner` and submitted to the `/gas_sponsorship/prepare` endpoint."""
    spender: NotRequired[Nullable[str]]
    r"""The address of the wallet which will send the transaction. This only needs to be set when `action` is 'DEPOSIT' and `gas_sponsorship` is `true`."""


class EarnTransferRequest(BaseModel):
    owner: str
    r"""The owner's wallet address."""

    chain: Chain
    r"""The chain to use."""

    token: str
    r"""The token you would like to transfer."""

    amount: EarnTransferRequestAmount
    r"""The amount of 'token' to transfer."""

    action: EarnTransferRequestAction
    r"""Whether you are depositing to or withdrawing from your earn account."""

    gas_sponsorship: Optional[bool] = None
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 signature data will be returned that must be signed by the `owner` and submitted to the `/gas_sponsorship/prepare` endpoint."""

    spender: OptionalNullable[str] = UNSET
    r"""The address of the wallet which will send the transaction. This only needs to be set when `action` is 'DEPOSIT' and `gas_sponsorship` is `true`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["gas_sponsorship", "spender"]
        nullable_fields = ["spender"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
