"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chain import Chain
from compass_api_sdk.types import BaseModel
from typing import Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


EarnSwapRequestAmountInTypedDict = TypeAliasType(
    "EarnSwapRequestAmountInTypedDict", Union[float, str]
)
r"""Human-readable amount of `token_in` to swap (token units, not wei)."""


EarnSwapRequestAmountIn = TypeAliasType("EarnSwapRequestAmountIn", Union[float, str])
r"""Human-readable amount of `token_in` to swap (token units, not wei)."""


SlippageTypedDict = TypeAliasType("SlippageTypedDict", Union[float, str])
r"""Maximum slippage tolerance as a percentage (e.g., 0.5 = 0.5%)."""


Slippage = TypeAliasType("Slippage", Union[float, str])
r"""Maximum slippage tolerance as a percentage (e.g., 0.5 = 0.5%)."""


class EarnSwapRequestTypedDict(TypedDict):
    owner: str
    r"""The owner's wallet address."""
    chain: Chain
    r"""The chain to use."""
    token_in: str
    r"""Token to sell (input). Provide a token symbol from a limited set (e.g., 'USDC') or any token address."""
    token_out: str
    r"""Token to buy (output). Provide a token symbol from a limited set (e.g., 'USDT') or any token address."""
    amount_in: EarnSwapRequestAmountInTypedDict
    r"""Human-readable amount of `token_in` to swap (token units, not wei)."""
    slippage: SlippageTypedDict
    r"""Maximum slippage tolerance as a percentage (e.g., 0.5 = 0.5%)."""
    gas_sponsorship: NotRequired[bool]
    r"""Optionally request gas sponsorship. If `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""


class EarnSwapRequest(BaseModel):
    owner: str
    r"""The owner's wallet address."""

    chain: Chain
    r"""The chain to use."""

    token_in: str
    r"""Token to sell (input). Provide a token symbol from a limited set (e.g., 'USDC') or any token address."""

    token_out: str
    r"""Token to buy (output). Provide a token symbol from a limited set (e.g., 'USDT') or any token address."""

    amount_in: EarnSwapRequestAmountIn
    r"""Human-readable amount of `token_in` to swap (token units, not wei)."""

    slippage: Slippage
    r"""Maximum slippage tolerance as a percentage (e.g., 0.5 = 0.5%)."""

    gas_sponsorship: Optional[bool] = None
    r"""Optionally request gas sponsorship. If `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""
