"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .aavevenue import AaveVenue, AaveVenueTypedDict
from .chain import Chain
from .fee import Fee, FeeTypedDict
from .vaultvenue import VaultVenue, VaultVenueTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import get_discriminator
from enum import Enum
from pydantic import Discriminator, Tag, model_serializer
from typing import Any, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


VenueTypedDict = TypeAliasType(
    "VenueTypedDict", Union[VaultVenueTypedDict, AaveVenueTypedDict]
)
r"""The earn venue."""


Venue = Annotated[
    Union[Annotated[AaveVenue, Tag("AAVE")], Annotated[VaultVenue, Tag("VAULT")]],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]
r"""The earn venue."""


class EarnManageRequestAction(str, Enum):
    r"""Whether you are depositing into or withdrawing from the given Earn `venue`."""

    DEPOSIT = "DEPOSIT"
    WITHDRAW = "WITHDRAW"


class EarnManageRequestTypedDict(TypedDict):
    owner: str
    r"""The primary wallet address that owns and controls the Earn Account."""
    chain: Chain
    r"""The chain to use."""
    venue: VenueTypedDict
    r"""The earn venue."""
    action: EarnManageRequestAction
    r"""Whether you are depositing into or withdrawing from the given Earn `venue`."""
    amount: Any
    r"""Amount of the underlying asset to act on (deposit or withdraw). For VAULT, this is the vault’s underlying token; for AAVE, this is the Aave reserve asset. Provide as a decimal in token units (not wei); must be > 0."""
    gas_sponsorship: NotRequired[bool]
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""
    fee: NotRequired[Nullable[FeeTypedDict]]
    r"""Optional fee configuration. If provided, a fee will be applied to the transaction amount and sent to the specified recipient address. The fee can be specified as a percentage of the transaction amount or as a fixed token amount."""


class EarnManageRequest(BaseModel):
    owner: str
    r"""The primary wallet address that owns and controls the Earn Account."""

    chain: Chain
    r"""The chain to use."""

    venue: Venue
    r"""The earn venue."""

    action: EarnManageRequestAction
    r"""Whether you are depositing into or withdrawing from the given Earn `venue`."""

    amount: Any
    r"""Amount of the underlying asset to act on (deposit or withdraw). For VAULT, this is the vault’s underlying token; for AAVE, this is the Aave reserve asset. Provide as a decimal in token units (not wei); must be > 0."""

    gas_sponsorship: Optional[bool] = None
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""

    fee: OptionalNullable[Fee] = UNSET
    r"""Optional fee configuration. If provided, a fee will be applied to the transaction amount and sent to the specified recipient address. The fee can be specified as a percentage of the transaction amount or as a fixed token amount."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["gas_sponsorship", "fee"]
        nullable_fields = ["fee"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
