"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .movement10percent import Movement10Percent, Movement10PercentTypedDict
from .yieldrange import YieldRange, YieldRangeTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class DetailsTypedDict(TypedDict):
    liquidity: float
    pendle_apy: float
    implied_apy: float
    fee_rate: float
    yield_range: YieldRangeTypedDict
    aggregated_apy: float
    max_boosted_apy: float
    movement10_percent: NotRequired[Nullable[Movement10PercentTypedDict]]


class Details(BaseModel):
    liquidity: float

    pendle_apy: Annotated[float, pydantic.Field(alias="pendleApy")]

    implied_apy: Annotated[float, pydantic.Field(alias="impliedApy")]

    fee_rate: Annotated[float, pydantic.Field(alias="feeRate")]

    yield_range: Annotated[YieldRange, pydantic.Field(alias="yieldRange")]

    aggregated_apy: Annotated[float, pydantic.Field(alias="aggregatedApy")]

    max_boosted_apy: Annotated[float, pydantic.Field(alias="maxBoostedApy")]

    movement10_percent: Annotated[
        OptionalNullable[Movement10Percent], pydantic.Field(alias="movement10Percent")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["movement10Percent"]
        nullable_fields = ["movement10Percent"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
