"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .batchedsafeoperationsresponse_output import (
    BatchedSafeOperationsResponseOutput,
    BatchedSafeOperationsResponseOutputTypedDict,
)
from .unsignedtransaction import UnsignedTransaction, UnsignedTransactionTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class DepositForBurnResponseTransferMode(str, Enum):
    r"""The transfer speed mode used. 'fast' uses confirmed finality (~30s), 'standard' uses full finality (~15-19 min)."""

    FAST = "fast"
    STANDARD = "standard"


class DepositForBurnResponseTypedDict(TypedDict):
    r"""Response model for CCTP depositForBurn transaction from a smart account.

    Contains either an unsigned transaction for direct submission or EIP-712 typed data
    for gas-sponsored transactions. Also includes a bridge_id for tracking the cross-
    chain transfer.
    """

    transaction: Nullable[UnsignedTransactionTypedDict]
    eip_712: Nullable[BatchedSafeOperationsResponseOutputTypedDict]
    transfer_mode: DepositForBurnResponseTransferMode
    r"""The transfer speed mode used. 'fast' uses confirmed finality (~30s), 'standard' uses full finality (~15-19 min)."""
    estimated_time_seconds: int
    r"""Estimated time to complete the bridge in seconds."""
    bridge_id: NotRequired[Nullable[str]]
    r"""Unique bridge identifier for tracking this cross-chain transfer. Use this ID when calling /mint/prepare to complete the transfer. Only present when Redis is configured on the server."""
    fee: NotRequired[Nullable[str]]
    r"""Fee amount in USDC charged for this transfer. Only present for fast mode. Standard mode transfers are free (fee is None or 0)."""


class DepositForBurnResponse(BaseModel):
    r"""Response model for CCTP depositForBurn transaction from a smart account.

    Contains either an unsigned transaction for direct submission or EIP-712 typed data
    for gas-sponsored transactions. Also includes a bridge_id for tracking the cross-
    chain transfer.
    """

    transaction: Nullable[UnsignedTransaction]

    eip_712: Nullable[BatchedSafeOperationsResponseOutput]

    transfer_mode: DepositForBurnResponseTransferMode
    r"""The transfer speed mode used. 'fast' uses confirmed finality (~30s), 'standard' uses full finality (~15-19 min)."""

    estimated_time_seconds: int
    r"""Estimated time to complete the bridge in seconds."""

    bridge_id: OptionalNullable[str] = UNSET
    r"""Unique bridge identifier for tracking this cross-chain transfer. Use this ID when calling /mint/prepare to complete the transfer. Only present when Redis is configured on the server."""

    fee: OptionalNullable[str] = UNSET
    r"""Fee amount in USDC charged for this transfer. Only present for fast mode. Standard mode transfers are free (fee is None or 0)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["bridge_id", "fee"]
        nullable_fields = ["bridge_id", "transaction", "eip_712", "fee"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
