"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from enum import Enum
from typing import Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


class DepositForBurnRequestChain(str, Enum):
    r"""The source chain where USDC will be burned."""

    ETHEREUM = "ethereum"
    ARBITRUM = "arbitrum"
    BASE = "base"


DepositForBurnRequestAmountTypedDict = TypeAliasType(
    "DepositForBurnRequestAmountTypedDict", Union[float, str]
)
r"""The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC)."""


DepositForBurnRequestAmount = TypeAliasType(
    "DepositForBurnRequestAmount", Union[float, str]
)
r"""The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC)."""


class DestinationChain(str, Enum):
    r"""The destination chain where USDC will be minted."""

    ETHEREUM = "ethereum"
    ARBITRUM = "arbitrum"
    BASE = "base"


class DepositForBurnRequestTransferMode(str, Enum):
    r"""Transfer speed mode. 'fast': ~30 second transfers using confirmed finality (requires a small fee taken from transfer amount). 'standard': ~15-19 minute transfers using full finality (free, no fee). Default is 'standard'."""

    FAST = "fast"
    STANDARD = "standard"


class DepositForBurnRequestTypedDict(TypedDict):
    owner: str
    r"""The primary wallet address that owns and controls the Product Account."""
    chain: DepositForBurnRequestChain
    r"""The source chain where USDC will be burned."""
    amount: DepositForBurnRequestAmountTypedDict
    r"""The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC)."""
    destination_chain: DestinationChain
    r"""The destination chain where USDC will be minted."""
    gas_sponsorship: NotRequired[bool]
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""
    transfer_mode: NotRequired[DepositForBurnRequestTransferMode]
    r"""Transfer speed mode. 'fast': ~30 second transfers using confirmed finality (requires a small fee taken from transfer amount). 'standard': ~15-19 minute transfers using full finality (free, no fee). Default is 'standard'."""


class DepositForBurnRequest(BaseModel):
    owner: str
    r"""The primary wallet address that owns and controls the Product Account."""

    chain: DepositForBurnRequestChain
    r"""The source chain where USDC will be burned."""

    amount: DepositForBurnRequestAmount
    r"""The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC)."""

    destination_chain: DestinationChain
    r"""The destination chain where USDC will be minted."""

    gas_sponsorship: Optional[bool] = None
    r"""Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`)."""

    transfer_mode: Optional[DepositForBurnRequestTransferMode] = None
    r"""Transfer speed mode. 'fast': ~30 second transfers using confirmed finality (requires a small fee taken from transfer amount). 'standard': ~15-19 minute transfers using full finality (free, no fee). Default is 'standard'."""
